#include <cstdio>
#include <iostream>
#include <cmath>
#include <algorithm>
#include <vector>
#include <map>
#include <cstring>
#include <string>
#include <set>
#include <iomanip>
using namespace std;
#define fname ""
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(s) s.begin(),s.end()
#define pb push_back
#define mp make_pair
#define F first
#define S second
const int maxn = (int)1e6;
const int inf = (1 << 30) - 1;

struct Edge {
	int a, b, c, f;
};

Edge edge[maxn];

int n, m, ans, sz, used[maxn], was[maxn], cnt;
vector <int> g[maxn], p[maxn];

void init() {
	for (int i = 1; i <= n; ++i) {
		g[i].clear();
		p[i].clear();
		was[i] = false;
	}
	sz = ans = cnt = 0;
	return;
}

void add_edge(int a, int b, int c) {
	edge[sz].a = a;
	edge[sz].b = b;
	edge[sz].c = c;
	edge[sz].f = 0;

	p[b].pb(sz);
	g[a].pb(sz++);

	edge[sz].a = b;
	edge[sz].b = a;
	edge[sz].c = 0;
	edge[sz].f = 0;

	p[a].pb(sz);
	g[b].pb(sz++);
	return;
}

bool dfs(int v, int t, int flow) {
	if (used[v] || !flow)
		return false;
	used[v] = true;
	if (v == t)
		return true;
	int to, id;
	for (int i = 0; i < (int)g[v].size(); ++i) {
		id = g[v][i];
		to = edge[id].b;

		if (dfs(to, t, min(flow, edge[id].c - edge[id].f))) {
			edge[id].f++;
			edge[id ^ 1].f--;
			return true;
		}
	}
	return false;
}

void bfs(int v) {
	if (was[v])
		return;
	was[v] = true;

	int id, to;
	for (int i = 0; i < (int)g[v].size(); ++i) {
		id = g[v][i];
		to = edge[id].b;

		if (edge[id].c - edge[id].f > 0)
			bfs(to);
	}

	return;
}

int s, t, a, b;

int main()
{
//	freopen(fname"in", "r", stdin);
//	freopen(fname"out", "w", stdout);
	
	while (true) {
		scanf("%d%d%d%d", &n, &m, &s, &t);
		if (!n)
			break;
		init();
		for (int i = 0; i < m; ++i) {
			scanf("%d%d", &a, &b);
			add_edge(a, b, 1);
		}
		while (true) {
			for (int i = 1; i <= n; ++i)
				used[i] = 0;
			if (dfs(s, t, 1))
				++ans;
			else
				break;
		}
		bfs(s);
		bool flag = false;
		for (int i = 0; i < sz; i += 2)
			if (!was[edge[i].a] && was[edge[i].b])
				flag = true, ++cnt;
		printf("%d %d\n", ans + flag, cnt);
	}

	return 0;
}
